/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarEventInstance;
import corgitaco.enhancedcelestials.LunarForecast;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.save.LunarEventSavedData;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import net.minecraft.class_124;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;

public class LunarForecastCommand {
    public static ArgumentBuilder<class_2168, ?> register(CommandDispatcher<class_2168> dispatcher) {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"lunarForecast").executes(cs -> LunarForecastCommand.setLunarEvent((class_2168)cs.getSource()))).then(class_2170.method_9247((String)"recompute").executes(cs -> LunarForecastCommand.recompute((class_2168)cs.getSource())));
    }

    public static int recompute(class_2168 source) {
        class_3218 world = source.method_9225();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext == null) {
            source.method_9213((class_2561)new class_2588("enhancedcelestials.commands.disabled"));
            return 0;
        }
        LunarForecast lunarForecast = lunarContext.getLunarForecast();
        lunarForecast.getForecast().clear();
        lunarForecast.setLastCheckedGameTime(Long.MIN_VALUE);
        lunarContext.computeLunarForecast(world, lunarForecast, world.method_8510());
        LunarEventSavedData.get((class_1936)world).setForecast(lunarContext.getLunarForecast());
        source.method_9226((class_2561)new class_2588("enhancedcelestials.lunarforecast.recompute"), true);
        return 1;
    }

    public static int setLunarEvent(class_2168 source) {
        class_3218 world = source.method_9225();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext == null) {
            source.method_9213((class_2561)new class_2588("enhancedcelestials.commands.disabled"));
            return 0;
        }
        long dayLength = lunarContext.getLunarTimeSettings().getDayLength();
        long currentDay = world.method_8532() / dayLength;
        class_2588 textComponent = null;
        LunarForecast lunarForecast = lunarContext.getLunarForecast();
        for (int i = Math.min(100, lunarForecast.getForecast().size() - 1); i > 0; --i) {
            LunarEventInstance lunarEventInstance = lunarForecast.getForecast().get(i);
            LunarEvent event = lunarEventInstance.getEvent(lunarContext.getLunarEvents());
            CustomTranslationTextComponent name = event.getTextComponents().getName();
            if (textComponent == null) {
                textComponent = new class_2588(name.method_11022());
            } else {
                textComponent.method_27693(", ").method_10852((class_2561)new class_2588(name.method_11022()));
            }
            textComponent.method_10852((class_2561)new class_2588("enhancedcelestials.lunarforecast.days_left", new Object[]{lunarEventInstance.getDaysUntil(currentDay)}));
        }
        if (textComponent != null) {
            source.method_9226((class_2561)new class_2588("enhancedcelestials.lunarforecast.header", new Object[]{textComponent.method_27693(".")}), true);
        } else {
            source.method_9226((class_2561)new class_2588("enhancedcelestials.lunarforecast.empty", new Object[]{textComponent}).method_27692(class_124.field_1054), true);
        }
        return 1;
    }
}

